
/* Program for calculating heat index by Greg Nowak <greg@romuald.net.eu.org>.
Heat index formula taken from http://www.usatoday.com/weather/whicalc.htm */
// June 09, 2004


#include <iostream>
#include <cstdlib>
#include <cmath>
using namespace std;


double calc_hi (double, double);

int
main (int argc, char *argv[])
{
  double temp;
  double humidity;
  double result;
  result = temp = humidity = 0.0;


  if (argc == 1)
    {
      cout <<
	"\nProgram for calculating heat index by Greg Nowak <greg@romuald.net.eu.org>.\n";
      cout << "\nNo command line arguments found.\n";
      cout <<
	"In the future, you may pass temperature in Fahrenheit, and relative humidity, in percent, without the percent\n"
	<< "sign as arguments.\n\n";

      cout << "Please enter the temperature in Fahrenheit:\n";
      cin >> temp;
      cout <<
	"\nPlease enter the relative humidity, in percent, without the percent sign (E.G. 65):\n";
      cin >> humidity;
    }

  else if (argc == 2)
    {
      cout <<
	"Please enter the relative humidity, in percent, without the percent sign (E.G. 65):\n";
      cin >> humidity;
      temp = atof (argv[1]);
    }

  else
    {
      temp = atof (argv[1]);
      humidity = atof (argv[2]);
    }

  result = round (calc_hi (temp, humidity));

// uncomment the line below to get an exact result without rounding
// result = calc_hi (temp, humidity);

  cout << "\nThe heat index is " << result << " degrees Fahrenheit.\n\n";

  return 0;
}

double
calc_hi (double t, double h)
{
// If anything other then numerical values and/or a period is passed to either argument of this function, the resulting return value is undefined.

  double result = -42.379;
  result += 2.04901523 * t;
  result += 10.14333127 * h;
  result -= 0.22475541 * t * h;
  result -= 6.83783 * pow (10.0, -3.0) * pow (t, 2.0);
  result -= 5.481717 * pow (10.0, -2.0) * pow (h, 2.0);
  result += 1.22874 * pow (10.0, -3.0) * pow (t, 2.0) * h;
  result += 8.5282 * pow (10.0, -4.0) * t * pow (h, 2.0);
  result -= 1.99 * pow (10.0, -6.0) * pow (t, 2.0) * pow (h, 2.0);
  return result;
}
